/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.bauble;

import com.lothrazar.cyclic.item.bauble.ItemBaseToggle;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.util.CharmUtil;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilParticle;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class CharmBase
extends ItemBaseToggle {
    public static ForgeConfigSpec.IntValue CHARM_LUCK;
    public static ForgeConfigSpec.DoubleValue CHARM_SPEED;
    public static ForgeConfigSpec.DoubleValue CHARM_ATTACKSPEED;
    private static final int FIREPROTSECONDS = 10;
    private static final int FALLDISTANCESECONDS = 5;
    private static final int FALLDISTANCELIMIT = 5;
    public static final UUID ID_SPEED;
    public static final UUID ID_LUCK;
    public static final UUID ID_ATTACKSPEED;
    boolean fireProt;
    boolean poisonProt;
    boolean witherProt;
    boolean voidProt;
    boolean wingCharm;
    boolean sailboatCharm;

    public CharmBase(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.canUse(stack)) {
            return;
        }
        if (!this.isOn(stack)) {
            return;
        }
        this.tryVoidTick(stack, worldIn, entityIn);
        if (!(entityIn instanceof LivingEntity)) {
            return;
        }
        if (!this.isOn(stack)) {
            return;
        }
        LivingEntity living = (LivingEntity)entityIn;
        this.tryPoisonTick(stack, entityIn, living);
        this.tryWitherTick(stack, entityIn, living);
        this.tryWingTick(stack, entityIn, living);
        this.tryFireTick(stack, living);
    }

    private void tryWingTick(ItemStack stack, Entity entityIn, LivingEntity living) {
        if (this.wingCharm && living.f_19789_ > 5.0f && !living.m_21023_(MobEffects.f_19591_)) {
            MobEffectInstance eff = new MobEffectInstance(MobEffects.f_19591_, 100, 0);
            living.m_7292_(eff);
            UtilItemStack.damageItem(living, stack);
            UtilSound.playSound((Entity)living, SoundEvents.f_12021_);
        }
    }

    private void tryFireTick(ItemStack stack, LivingEntity living) {
        if (this.fireProt && living.m_6060_() && !living.m_21023_(MobEffects.f_19607_)) {
            MobEffectInstance eff = new MobEffectInstance(MobEffects.f_19607_, 200, 0);
            eff.f_19508_ = false;
            living.m_7292_(eff);
            UtilItemStack.damageItem(living, stack);
            UtilSound.playSound((Entity)living, SoundEvents.f_11937_);
            UtilParticle.spawnParticle(living.f_19853_, (ParticleOptions)ParticleTypes.f_123803_, living.m_142538_(), 9);
        }
    }

    private void tryWitherTick(ItemStack stack, Entity entityIn, LivingEntity living) {
        if (this.witherProt && living.m_21023_(MobEffects.f_19615_)) {
            living.m_6234_(MobEffects.f_19615_);
            UtilItemStack.damageItem(living, stack);
            UtilSound.playSound(entityIn, SoundEvents.f_11911_);
        }
    }

    private void tryPoisonTick(ItemStack stack, Entity entityIn, LivingEntity living) {
        if (this.poisonProt && living.m_21023_(MobEffects.f_19614_)) {
            living.m_6234_(MobEffects.f_19614_);
            UtilItemStack.damageItem(living, stack);
            UtilSound.playSound(entityIn, SoundEvents.f_11911_);
        }
    }

    private void tryVoidTick(ItemStack stack, Level worldIn, Entity entityIn) {
        int minY = worldIn.m_6042_().m_156732_();
        int maxY = worldIn.m_6042_().m_63964_();
        if (this.voidProt && entityIn.m_142538_().m_123342_() < minY - 40 && entityIn instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityIn;
            UtilEntity.enderTeleportEvent(entity, worldIn, new BlockPos(entityIn.m_142538_().m_123341_(), maxY, entityIn.m_142538_().m_123343_()));
            UtilItemStack.damageItem(entity, stack);
            UtilSound.playSound(entityIn, SoundEvents.f_11852_);
        }
    }

    private static void toggleAttribute(Player player, Item charm, Attribute attr, UUID id, float factor, int flatIncrease) {
        ItemStack charmStack = CharmUtil.getIfEnabled(player, charm);
        AttributeInstance attrPlayer = player.m_21051_(attr);
        AttributeModifier oldValue = attrPlayer.m_22111_(id);
        if (charmStack.m_41619_()) {
            if (oldValue != null) {
                attrPlayer.m_22120_(id);
            }
        } else {
            if (oldValue == null) {
                double baseSpeed = attrPlayer.m_22115_();
                AttributeModifier newValue = new AttributeModifier(id, "Bonus from cyclic", baseSpeed * (double)factor + (double)flatIncrease, AttributeModifier.Operation.ADDITION);
                attrPlayer.m_22125_(newValue);
                UtilItemStack.damageItem((LivingEntity)player, charmStack);
            }
            UtilItemStack.damageItemRandomly((LivingEntity)player, charmStack);
        }
    }

    public static void charmSpeed(Player player) {
        CharmBase.toggleAttribute(player, (Item)ItemRegistry.CHARM_SPEED.get(), Attributes.f_22279_, ID_SPEED, ((Double)CHARM_SPEED.get()).floatValue(), 0);
    }

    public static void charmLuck(Player player) {
        CharmBase.toggleAttribute(player, (Item)ItemRegistry.CHARM_LUCK.get(), Attributes.f_22286_, ID_LUCK, 0.0f, (Integer)CHARM_LUCK.get());
    }

    public static void charmAttackSpeed(Player player) {
        CharmBase.toggleAttribute(player, (Item)ItemRegistry.CHARM_ATTACKSPEED.get(), Attributes.f_22283_, ID_ATTACKSPEED, ((Double)CHARM_ATTACKSPEED.get()).floatValue(), 0);
    }

    public static void charmExpSpeed(Player player) {
        ItemStack charmStack = CharmUtil.getIfEnabled(player, (Item)ItemRegistry.CHARM_XPSPEED.get());
        if (!charmStack.m_41619_()) {
            player.f_36101_ = 0;
        }
    }

    static {
        ID_SPEED = UUID.fromString("12230aa2-eff2-4a81-b92b-a1cb95f115c6");
        ID_LUCK = UUID.fromString("acc30aa2-eff2-4a81-b92b-a1cb95f115c6");
        ID_ATTACKSPEED = UUID.fromString("b4678aa2-eff2-4a81-b92b-a1cb95f115c6");
    }
}

